from flask import Flask
from werkzeug.exceptions import NotFound
import json
import requests
import os

app = Flask(__name__)
movies_service = "http://movieservice:5001/movies/{}"
showtimes_db = f"{os.getcwd()}/database/showtimes.json"

with open(showtimes_db, "r") as f:
    showtimes = json.load(f)


@app.route("/", methods=['GET'])
def hello():
    endpoints = {
        "uri": "/",
        "subresource_uris": {
            "showtimes": "/showtimes",
            "showtime": "/showtimes/<date>"
        }
    }
    return json.dumps(endpoints)


@app.route("/showtimes", methods=['GET'])
def showtimes_list():
    return json.dumps(showtimes)


@app.route("/showtimes/<date>", methods=['GET'])
def showtimes_record(date):
    if date not in showtimes:
        raise NotFound
    print(showtimes[date])
    result = []
    for movie_id in showtimes[date]:
        resp = requests.get(movies_service.format(movie_id))
        result.append(resp.json()["title"])
    return json.dumps(result)

if __name__ == "__main__":
    app.run(host="0.0.0.0",port=5002, debug=True)
