

/*
 * Header file for the interpolation functions used by BSE
 */
/*******************************************/

#ifndef ZFUNCS_PROTOTYPES_H
#define ZFUNCS_PROTOTYPES_H
#include "../binary_c_parameters.h"
#ifdef BSE
#include "../binary_c_structures.h"
#include "../binary_c_code_options.h"
#include "../binary_c_prototypes.h"

double Pure_function mbagbf(const double mc, 
                            const double * RESTRICT const giant_branch_parameters);
double Pure_function ltmsf(const double m, 
                           const double * RESTRICT const main_sequence_parameters) ;
double Pure_function rtmsf(const double m, 
                           const double * RESTRICT const main_sequence_parameters);
double Pure_function lalphf(const double m, 
                            const double * RESTRICT const main_sequence_parameters) ;
double Pure_function ralphf(const double m, 
                            const double * RESTRICT const main_sequence_parameters) ;
double Pure_function lbetaf(const double m, 
                            const double * RESTRICT const main_sequence_parameters) ;
double Pure_function lnetaf(const double m, 
                            const double * RESTRICT const main_sequence_parameters) ;
double Pure_function rgammf(const double m, 
                            const double * RESTRICT const main_sequence_parameters) ;
double Pure_function lzamsf(const double m, 
                            const double * RESTRICT const main_sequence_parameters) ;
double Pure_function rzamsf(const double m, 
                            const double * RESTRICT const main_sequence_parameters) ;
double Pure_function mheif(const double m, 
                           const double mhefl, 
                           const double mchefl,
                           const double * RESTRICT const giant_branch_parameters);
double Pure_function lbagbf(const double m,
                            const double mhefl, 
                            const double * RESTRICT const giant_branch_parameters);
double Pure_function ragbf(const double m, 
                           const double lum,
                           const double mhelf, 
                           const double * RESTRICT const giant_branch_parameters
#ifdef AXEL_RGBF_FIX
                           ,const double z
#endif
    );

double Pure_function thef(const double m, 
                          const double mc,
                          const double mhefl,
                          const double * RESTRICT const giant_branch_parameters);
	    
Constant_function double themsf(const double m );
double tbgbf(struct stardata_t * stardata,
             const double m,
	     const double * RESTRICT const main_sequence_parameters,
	     const double metallicity);
double Pure_function lheif( double m, 
                            const double mhefl, 
                            const double * RESTRICT const giant_branch_parameters);
double Pure_function rminf(const double m, 
                           const double * RESTRICT const giant_branch_parameters);
Constant_function double rzhef(const double m);
double Pure_function tblf(const double m, 
                          const double mhefl,
                          const double mfgb, 
                          const double * RESTRICT const giant_branch_parameters,
                          const Abundance z) ;
double Pure_function lhef(const double m, 
                          const double * RESTRICT const giant_branch_parameters/**this replaces common block GBCFF*/
    );

Constant_function double lzhef(const double m);

double Pure_function thookf(const double m,
                            const double * RESTRICT const main_sequence_parameters);
double Pure_function lzahbf(const double m, 
                            const double mc, 
                            const double mhefl, 
                            const double * RESTRICT const giant_branch_parameters) ;
double Pure_function rzahbf(const double m, 
                            const double mc, 
                            const double mhefl, 
                            const double * RESTRICT const giant_branch_parameters) ;
double Pure_function mcagbf(const double m, 
                            const double * RESTRICT const giant_branch_parameters);
double Pure_function lgbtf(const double t,
                           const double A,
                           const double * RESTRICT GB,
                           const double tinf1,
                           const double tinf2,
                           const double tx);

double Pure_function lbgbf(const double m, 
                           const double * RESTRICT const giant_branch_parameters);

double Pure_function lbgbdf(const double m, 
                            const double * RESTRICT const giant_branch_parameters);
double Pure_function lmcgbf(const double m, 
                            const double * RESTRICT GB);
double Pure_function mcgbf(const double lum,
                           const double * RESTRICT const GB,
                           const double lx);
            
            
double Pure_function mcheif(const double m, 
                            const double mhefl,
                            const double mchefl,
                            const double * RESTRICT const giant_branch_parameters);
double Pure_function rgbf(const double m, 
                          const double lum,
                          const double * RESTRICT const giant_branch_parameters);
double Pure_function rhookf(const double m ,
                            const double mhook,
                            const double * RESTRICT const main_sequence_parameters);
double Pure_function lhookf(const double m ,
                            const double mhook,
                            const double * RESTRICT const main_sequence_parameters);
Constant_function double mctmsf(const double m);

double rhelmf(Stellar_type * const stellar_type,
              const double m, 
	      const double lum, 
	      const double rx, 
	      const double lx);
Constant_function double lpertf(const double m, 
                                const double mew);
Constant_function double rpertf(const double m, 
                                const double mew, 
                                const double r, 
                                const double rc);
double Pure_function mcgbtf(const double t,
                            const double A,
                            const double * RESTRICT GB,
                            const double tinf1,
                            const double tinf2,
                            const double tx);
double Pure_function dmcgbtf_dt(const double t,
                                const double A,
                                const double * RESTRICT GB,
                                const double tinf1,
                                const double tinf2,
                                const double tx);
             
double Pure_function rbetaf(const double m, 
                            const double * RESTRICT const main_sequence_parameters);

Constant_function double menvf(const int stellar_type,
                               const double m,
                               const double mc,
                               const double age,
                               const double tm,
                               const double tbgb);
double Pure_function renvf(const Stellar_type stellar_type,
                           const double m,
                           const double r,
                           const double rc,
                           const double age,
                           const double tm,
                           const double tbgb,
                           const double * RESTRICT const main_sequence_parameters );

Constant_function double rhehgf(const double m,
                                const double lum,
                                const double rx,
                                const double lx);
Constant_function double rhegbf(const double lum);

double Pure_function lum_mc_EAGB(const double mc,
                                 const double * RESTRICT const GB);

double Pure_function mcx_eagbf(const double t,
                               const double A,
                               const double * RESTRICT const GB,
                               const double tinf1,
                               const double tinf2,
                               const double tx
    );

Constant_function double mass_CO_core_at_BAGB(const double m,
                                              const Abundance z);


double Pure_function rwd(const double m,
                         struct stardata_t * const stardata);
double Pure_function lwd(const double m,
                         const double age,
                         const Stellar_type st,
                         struct stardata_t * RESTRICT const stardata);
double fphase(struct stardata_t * const stardata,
              const double t,
              const struct star_t * const star);



void main_sequence_strip(const double effective_zams_mass, // ZAMS mass
			 const double fractional_age, // age/t_MS
			 const double mass, // M(t)
			 double * const fluminosity,
			 double * const fradius,
			 double * const drdm);



double Karakas2002_lumfunc(Stellar_type stellar_type,
                           const double m,
                           const double mc_1tp,
                           const double menv,
                           const double mcno3dup,
                           const double phase_start_mass,
                           const double num_thermal_pulses,
                           const double interpulse_period,
                           const double time_first_pulse,
                           const double time_next_pulse,
                           const double age,
                           const Abundance metallicity,
                           struct stardata_t * RESTRICT const stardata,
                           double * const GB);



double Karakas2002_ragb_teff(const double m,
                             const Abundance metallicity,
                             double l,
                             const double m0,
                             const double mc_1tp,
                             const double menv,
                             const double mcnodup,
                             struct star_t * const star,
                             struct stardata_t * const stardata);

double Karakas2002_radius_2param_m(struct stardata_t * const stardata,
                                   const double m0,
                                   const double m,
                                   const double z,
                                   const double l);
double Karakas2002_interpulse_period(struct stardata_t * RESTRICT const stardata,
                                     const double mc,
                                     const double m,
                                     const double mc_1tp,
                                     Abundance Z,
                                     const double lambda,
                                     const struct star_t * const star);
double Pure_function Karakas2002_mc1tp(double m,
                                       const double phase_start_mass,
                                       struct stardata_t * stardata);


#ifdef HALL_TOUT_2014_RADII
double Pure_function Hall_Tout_2014_low_mass_HG_RGB_radius(const double m,
                                                           struct stardata_t * RESTRICT const stardata);
double Pure_function Hall_Tout_2014_AGB_radius(const double m,
                                               struct stardata_t * RESTRICT const stardata);
double Constant_function Hall_Tout_2014_HeHG_radius(const double mc);
double Pure_function Hall_Tout_2014_HeGB_radius(const double mc,
                                                struct stardata_t * RESTRICT const stardata);


#endif
Constant_function double mc_heburn(double m);
double Constant_function dm_intershell(const double mc);
double Pure_function mcbgb(struct star_t * RESTRICT const s,
                           struct stardata_t * RESTRICT const stardata);

double Pure_function min_He_ignition_core_mass(struct stardata_t * RESTRICT const stardata,
                                               struct star_t * RESTRICT const star);
double Pure_function Hurley2002_mc1tp(const double phase_start_mass,
                                      struct stardata_t * RESTRICT const stardata);

#endif // BSE


/*
 * Other zfuncs which are not part of BSE's library
 * or that are used in other stellar evolution libraries.
 */
Constant_function double rbh(const double m);
Constant_function double rns(const double MAYBE_UNUSED m);
Constant_function double lns(const double m,const double age);


Constant_function double gamma_rot(const double mass, const double luminosity);

double Pure_function system_mass(struct stardata_t * stardata);
Constant_function double vrotf(const double m);
int Pure_function next_evolving_star(Star_number k,
                                     const struct stardata_t * RESTRICT const stardata);
int Pure_function next_nuclear_burning_star(Star_number k,
                                            const struct stardata_t * RESTRICT const stardata);
double Pure_function omegaspin(const struct star_t * RESTRICT const star);

double Pure_function WR_mu(const struct star_t * RESTRICT const star);

double Pure_function logg(const struct star_t * RESTRICT const star );
double Pure_function logLeff(const struct star_t * RESTRICT const star );



double Pure_function moment_of_inertia(const struct star_t * RESTRICT const star,
                                       const double r);
double Pure_function core_moment_of_inertia(const struct star_t * RESTRICT const star,
                                            const double rc);
double Pure_function envelope_moment_of_inertia(const struct star_t * RESTRICT const star,
                                                const double r);



Constant_function double r_rot(double f);
Constant_function double r_rot_inv(double f);
double guess_mc1tp(const double mass,
                   const double phase_start_mass,
                   const struct star_t * RESTRICT const star,
                   struct stardata_t * RESTRICT const stardata);

#ifdef SELMA_BETTER_TREATMENT_OF_MS_MERGERS
Constant_function double effective_core_mass_fraction_of_MS_stars(const double m,
                                                                  const double z);
#endif// SELMA_BETTER_TREATMENT_OF_MS_MERGERS

double Pure_function molecular_weight(const struct star_t * RESTRICT const star,
                                      const struct stardata_t * RESTRICT const stardata);
Constant_function double thick_disk_age(const double z);

Constant_function double m_conv_core(const double m,
                                 const double z,
                                 const double age,
                                 const double tms);
Constant_function double max_m_conv_core(const double m,
                                         const double z);
Constant_function double L_1DUP(const double m,
                                const double z);
double mc_1DUP(struct stardata_t * RESTRICT const stardata,
               const double m,
               const double z);
double menv_1DUP(struct stardata_t * RESTRICT const stardata,
                 const double m,
                 const double z);
double Constant_function m_1dup(const double m,
                                const double z);



double Pure_function dust_formation_radius(const struct star_t * RESTRICT const star);
double Pure_function condensation_temperature(const struct star_t * RESTRICT const star);

double Constant_function fallbackDelayed(const double MpreSN, 
                                         const double Mproto, 
                                         const double COCoreMass);
double Constant_function fallbackRapid(const double MpreSN, 
                                       const double Mproto,
                                       const double COCoreMass);
double Constant_function COCoreToProtoMassRapid(const double COCoreMass);
double Constant_function COCoreToProtoMassDelayed(const double COCoreMass);
double Constant_function massFallbackGeneral(const double MpreSN,
                                             const double Mproto,
                                             const double fb);
double Constant_function baryonicRemnantMassGeneral(const double Mproto, 
                                                    const double Mfb);
#ifdef PRE_MAIN_SEQUENCE
Constant_function double preMS_lifetime(const double mass);
Constant_function double preMS_radius_factor(double mass,
                                             const double time);
double time_from_preMS_radius_factor(struct stardata_t * RESTRICT const stardata,
                                     const double mass, 
				     const double radius_factor);
#endif // PRE_MAIN_SEQUENCE


#endif /* ZFUNCS_PROTOTYPES_H */
