#include "../binary_c.h"
#ifdef BSE
double Pure_function rwd(const double m,
                         struct stardata_t * stardata)
{
    /* 
     * WD radius.
     * Formula from Nauenberg (1972), adapted to prevent
     * the star from having zero radius as M->Mch.
     */
    double x = stardata->preferences->chandrasekhar_mass/m;
    x = cbrt(x);
    x *= x;
    double rwd = 0.01150*sqrt(Max(1.48204e-06,x - 1.0/x)); 
    Dprint("rwd (m=%g) = %g\n",m,rwd);
    return(rwd);
}

/*
 * You might want to consider the alternative expression:
 * R = 1e9 * (m/0.7)**(1/3) * (1-m/Mch)**0.5 * (mu_e/2)**(-5.0/3.0)
 *
 * Which gives, for he WDs, ~ twice the radius
 *
 * For COWDs the agreement is good within ~10-20% over most of the mass range
 *
 * (For helium mu_e ~ 4/3, For COWDs mu_e ~ 1.75)
 */
#endif//BSE
