#include "../binary_c.h"

#define PERTA 0.1

Constant_function double rpertf(const double m, 
                                const double mu, 
                                const double r, 
                                const double rc)
{
    /*
     * A function to obtain the exponent that perturbs radius.
     */
    if(Less_or_equal(mu,0.0)) return(0.0);
    const double b=0.006*Max(1.0,2.5/m);
    const double q=log(r/rc);
    double fac=PERTA/q;
    fac=Max(-50.0,Min(fac,-14.0/log10(mu)));
    double result=Pow3(mu/b);
    result = (1.0 + Pow3(b))* result* pow(mu,fac)/
        (1.0+result);
    Fix_range(result,0.0,1.0);
    return result;
}

