#include "../binary_c.h"

Constant_function double r_rot(double f)
{
    /*
     * Given the ratio of spin rates f=omega/omega_crit 
     * this is the ratio of equatorial to polar radius.
     * 
     * The polar radius is the same as the non-rotating radius
     * to within 2%. (See Maeder's book chapter 2)
     *
     * Data from Selma de Mink (thanks!)
     */

    f=Max(0.0,Min(1.0,f));
    //double rr=(pow(10.0,((1.04580e-02)*tan((1.48680e+00)*f)+(6.00900e-02)*sin(f))*f));
    double rr=pow(10.0,(1.75390e-02*tan(1.42200e+00*f)+4.51100e-02*sin(f))*f);
    return (rr);
}

Constant_function double r_rot_inv(double f)
{
    /* inverse of the above : given a bulge fraction (f), calculate the spin rate */
    f=Max(0.0,Min(log10(1.5),f));

    /* fit good to RMS 0.000115 */
    double rinv = 9.71220e-05+1.32160e+00*pow(1-pow(f/0.2-1,2),5.10440e-01)+-1.92740e+00*f+-4.14510e+00*f*f+2.89750e+01*f*f*f;

    return (rinv);
}
