
#include "../binary_c.h"

/*
 * If we're currently looping over star k,
 * return the next star number which is evolving
 * (i.e. not a MASSLESS_REMNANT).
 * 
 * In case we run off the end of the NUMBER_OF_STARS,
 * return -1, and if a negative number is passed in
 * also return -1.
 */

int Pure_function next_evolving_star(
    Star_number k,
    const struct stardata_t * RESTRICT const stardata)
{
    while(1)
    {
        k++;
        if(k<NUMBER_OF_STARS &&
           stardata->star[k].stellar_type == MASSLESS_REMNANT)
        {
            continue;
        }
        else
        {
            if(k>=NUMBER_OF_STARS) k = -1;
            break;
        }
    }
    return k;
}
