#include "../binary_c.h"
#ifdef BSE
double Pure_function mcheif(const double m, 
                            const double mhefl, 
                            const double mchefl,
                            const double * RESTRICT const giant_branch_parameters)
{
    double result;

    /*
     * A function to evaluate core mass at BGB or He ignition
     * (depending on mchefl) for IM & HM stars  (OP 25/11/97)
     *
     * This is Hurley 2000 Eq. 44 and associated text.
     */
    double a3 = Pow4(mchefl)-
        giant_branch_parameters[33]*
        pow(mhefl,giant_branch_parameters[34]);
    double a4 = giant_branch_parameters[33]*
        pow(m,giant_branch_parameters[34]);
    double mcbagb = mcagbf(m,giant_branch_parameters);
    result = Min(0.95*mcbagb,
                 sqrt(sqrt(a3+a4)));
 
    return result;
}

/***********************************************************/


#endif//BSE
