#include "../binary_c.h"

double Pure_function mbagbf(const double mc, /** mass of core **/
                            const double * RESTRICT const giant_branch_parameters)
{
    /*
     * A function to evaluate mass at the BAGB by inverting mcagbf.
     */
    double mc4; /** mc^4 **/
    double result;
  
    mc4 = Pow4(mc);
    if (mc4 > giant_branch_parameters[37])
    { 
        result = pow(((mc4 - giant_branch_parameters[37])/
                      giant_branch_parameters[35]),
                     (1.0/giant_branch_parameters[36]));
    }
    else
    {
        result = 0.0;
    }


    return (result);  
}

/*****************************************************************/

