#include "../binary_c.h"

double Constant_function massFallbackGeneral(const double MpreSN,
                                                const double Mproto,
                                                const double fb)
{
    /*
      Equation 11 in Fryer et al 2012
     
      Parameters
      -----------
      MpreSN : double
      Pre supernova stellar mass in Msol
      COCoreMass : double
      Pre supernova Carbon Oxygen (CO) core mass in Msol
      fb : double
      Fallback [0,1]
     
      Returns
      --------
      Mfb : double
      Mass falling back onto proto object
     
      -- Simon Stevenson
    */
    return fb * (MpreSN - Mproto);
}
