#include "../binary_c.h"

double Pure_function lzamsf(const double m, 
                            const double * RESTRICT const main_sequence_parameters)
{
#ifdef USE_BSE_MS_LR
    Exit_binary_c_no_stardata(BINARY_C_ALGORITHM_BRANCH_FAILURE,
                              "Trying to use rzamsf when function is not available\n");
    return 0.0;
#else// USE_BSE_MS_LR
    /* 
     * A function to evaluate Lzams
     * (from Tout et al., 1996, MNRAS, 281, 257).
     */
    const double sm=sqrt(m);
    const double m2=m*m;
    const double m3=m2*m;
    const double m5=m3*m2;
    const double m8=m5*m3;

    return (main_sequence_parameters[1]*m5*sm + 
            main_sequence_parameters[2]*m8*m3)/
        (main_sequence_parameters[3] + 
         m3 + 
         main_sequence_parameters[4]*m5 + 
         main_sequence_parameters[5]*m5*m2 +
         main_sequence_parameters[6]*m8+
         main_sequence_parameters[7]*m8*m*sm);
#endif
}
/***********************************************************/

