#include "../binary_c.h"
#ifdef BSE

double Pure_function lwd(const double m,
           const double age,
           const Stellar_type st,
           struct stardata_t * RESTRICT const stardata)
{
    double xx,l,q;

    /* calculates the luminosity of a WD */
    xx = (st==HeWD) ? AHE : ACO;
    q=xx*(age+0.1);

    /* Mestel cooling */
#ifdef MESTEL_COOLING
    l = 635.0*m*stardata->common.metallicity_parameters[14]*pow(q,-1.4);
#endif
#ifdef MODIFIED_MESTEL_COOLING
    l = 300.0*m*stardata->common.metallicity_parameters[14] *
        (age<9000.0) ? pow(q,-1.180) : pow(9000.10*xx,5.3)*pow(q,-6.48);
#endif

#ifdef NANCHECKS
    if(isnan(l)!=0)
    {
        Backtrace;
        Exit_binary_c(BINARY_C_EXIT_NAN,
                      "WD nan L breakage : M=%g age=%g st=%d xx=%g q=%g l=%g\n",
                      m,age,st,xx,q,l);
    }
#endif

    return(l);
}
#endif
