#include "../binary_c.h"

double Constant_function fallbackRapid(const double MpreSN, 
                                       const double Mproto,
                                       const double COCoreMass)
{
    /*
      Calculate fallback using the rapid prescription
     
      Equations 15 & 16 from Fryer et al 2012
     
      Parameters
      -----------
      MpreSN : double
      Pre supernova stellar mass in Msol
      Mproto : double
      Fe/Ni proto compact object mass in Msol
      COCoreMass : double
      Pre supernova CO core mass in Msol
     
      Returns
      ---------
      fb : double
      Fraction of mass falling back onto proto object
     
      -- Simon Stevenson
    */

    double fb;
    if(COCoreMass < 2.5)
    {
        fb = 0.2/(MpreSN - Mproto);
    }
    else if(COCoreMass < 6.0)
    {
        fb = (0.286 * COCoreMass - 0.514)/(MpreSN - Mproto);
    }
    else if(COCoreMass < 7.0)
    {
        fb = 1.0;
    }
    else if(COCoreMass < 11.0)
    {
        double a1 = 0.25 - (1.275/(MpreSN - Mproto));
        double b1 = -11.0 * a1 + 1.0;
        fb = a1 * COCoreMass + b1;
    }
    else 
    {
        fb = 1.0;
    }

    Clamp(fb,0.0,1.0);
    return fb;
}
