#include "../binary_c.h"


double Constant_function fallbackDelayed(const double MpreSN, 
                                         const double Mproto, 
                                         const double COCoreMass)
{
    /*
      Calculate fallback using the delayed prescription
     
      Equation 19 of Fryer et al 2012
     
      Parameters
      -----------
      MpreSN : double
      Pre supernova stellar mass in Msol
      Mproto : double
      Fe/Ni proto compact object mass in Msol
      COCoreMass : double
      Pre supernova CO core mass in Msol
     
      Returns
      --------
      fb : double, must be in the range 0 to 1
      Fallback
     
      -- Simon Stevenson
    */
    double fb;
    if(COCoreMass < 2.5)
    {
        fb = 0.2/(MpreSN - Mproto);
    }
    else if(COCoreMass < 3.5)
    {
        fb = (0.5 * COCoreMass - 1.05)/(MpreSN - Mproto);
    }
    else if(COCoreMass < 11.0)
    {
        double a2 = 0.133 - (0.093)/(MpreSN - Mproto);
        double b2 = -11.0 * a2 + 1.0;
        fb = a2 * COCoreMass + b2;
    }
    else
    {
        fb = 1.0;
    }
    
    Clamp(fb,0.0,1.0);

    return fb;
}

