#include "../binary_c.h"

double Pure_function dust_formation_radius(const struct star_t * RESTRICT const star)
{
    /*
     * Dust formation radius as in 
     * Abate et al. 2014,2015
     */
    return 0.5 * star->radius * 
        Pow2p5(Teff_from_star_struct(star) / condensation_temperature(star));
}
