#include "../binary_c.h"

double Constant_function baryonicRemnantMassGeneral(const double Mproto, 
                                                    const double Mfb)
{
    /*
      Equation 12 in Fryer et al 2012
     
      Parameters
      -----------
      Mproto : double
      Mass of proto compact object in Msol
      Mfb : double
      Mass falling back onto proto compact object Mfb = fb*(MpreSN - Mproto)
     
      Returns
      --------
      Mremnant, baryonic : double
      Baryonic mass of remnant
     
      -- Simon Stevenson
    */
    return Mproto + Mfb; //Mfb = fb*(MpreSN - Mproto);
}
