#include "../binary_c.h"

/*
 * The mu factor which determines whether a star is a WR star or not 
 * according to Hurley's prescription
 */


double Pure_function WR_mu(const struct star_t * RESTRICT const star)
{
    double mu;
    if((star->stellar_type>=HERTZSPRUNG_GAP)&&
       (star->stellar_type<=HeGB))
    {
        mu = (1.0-star->core_mass/star->mass)*
            Min(5.0,Max(1.20,pow((star->luminosity/LUM0),KAP)));

        if(star->stellar_type>=HeMS)mu=0.0;
    }
    else
    {
        // other stars: not WR
        mu=10.0;
    }

    return (mu);
}
