#include "../binary_c.h"

#ifdef HALL_TOUT_2014_RADII

double Pure_function Hall_Tout_2014_AGB_radius(const double mc,
                                               struct stardata_t * RESTRICT const stardata)
{

    /*
     * Radius of AGB stars from
     * Hall and Tout (2014) Appendix A. 
     */
    double fr = Cubic(mc,
                      7.342054,
                      -1.328317e+1,
                      1.020264e+1,
                      -2.786524);

    return fr * rwd(mc,stardata);
}
#endif // HALL_TOUT_2014_RADII
