#include "../binary_c.h"

double Constant_function COCoreToProtoMassDelayed(const double COCoreMass)
{
    /*
      Equation 18 in Fryer et al 2012
     
      Parameters
      -----------
      COCoreMass : double
      Mass of the CO core in Msol
     
      Returns
      --------
      Mproto : double
      Mass of the Fe/Ni proto core in Msol
     
      -- Simon Stevenson
    */
    return 
        COCoreMass < 3.5 ? 1.2 : 
        COCoreMass < 6.0 ? 1.3 : 
        COCoreMass < 11.0 ? 1.4 : 
        1.6;
}
