#include "wind.h"

Constant_function double wind_other(WIND_PROTOTYPE_ARGS)
{
    double mdot;

    /*
     * Mass loss rates not defined in any particular stellar phase
     */
    Dprint("Lcheck %g cf %g\n",luminosity,LARGE_LUMINOSITY);
    if(luminosity>LARGE_LUMINOSITY)
    {
        /*
         * Apply mass loss of Nieuwenhuijzen & de Jager, A&A,
         * 1990, 231, 134, for massive stars over the entire HRD.
         */
          
        mdot = 9.6E-15*pow(radius,0.81)*pow(luminosity,1.24)*
            pow(mass,0.16)*sqrt(metallicity/0.02);
#ifdef NIEUWENHUIJZEN_FUDGE_FACTOR
        double x = Min(1.0,(luminosity-LARGE_LUMINOSITY)/500.0);
        mdot *= x;
#endif      
        Dprint("N+dJ %g\n",mdot);
    }
    else
    {
        mdot = 0.0;
    }
    
    return mdot;
}
