#include "../binary_c.h"

double Constant_function wind_momentum_rate(struct star_t * RESTRICT star)
{
    /*
     * Wind momentum rate :
     * consider loss only, ignore accretion
     *
     * return in CGS units
     */
    double pdot =
        star->vwind *
        star->derivative[DERIVATIVE_STELLAR_MASS_WIND_LOSS] *
        1e5 * M_SUN / YEAR_LENGTH_IN_SECONDS;
    
    return pdot;
}
