#include "wind.h"

double wind_mass_loss_rate(WIND_PROTOTYPE_ARGS)
{
    /*
     * Calculate the wind mass loss rate from a star. 
     * 
     * mdot_wind contains the result, in Msun/year, which is
     * a positive number (and is returned).
     */
    double mdot_wind = 0.0; // result : returned
  
    switch(stardata->preferences->wind_mass_loss)
    {

    case WIND_ALGORITHM_NONE:
        /*
         * No wind - do nothing
         */
        mdot_wind = 0.0;
        break;
        
    case WIND_ALGORITHM_HURLEY2002:
        /*
         * Hurley et al (2002) prescription
         */

        mdot_wind = wind_Hurley2002(WIND_CALL_ARGS);
        break;
        
    case WIND_ALGORITHM_SCHNEIDER2018:
        /*
         * Fabian Schneider's 2018 routine
         */
        mdot_wind = wind_Schneider(WIND_CALL_ARGS);
        break;
        
    default:
        Exit_binary_c(BINARY_C_ALGORITHM_OUT_OF_RANGE,
                      "Wind mass loss prescription %u is unknown.\n",
                      stardata->preferences->wind_mass_loss);
    }
    
    Dprint("mdot_wind = %g from prescription %u\n",
           mdot_wind,
           stardata->preferences->wind_mass_loss);

    star->vwind = vwind(WIND_CALL_ARGS);

    return (mdot_wind);
}

