#pragma once
#ifndef WIND_MACROS_H
#define WIND_MACROS_H


/*
 * Wind algorithms
 */
#define WIND_ALGORITHM_NONE 0
#define WIND_ALGORITHM_HURLEY2002 1
#define WIND_ALGORITHM_SCHNEIDER2018 2


/* constants */
#define LBV_LUMINOSITY 6e+05
#define LARGE_LUMINOSITY 4000.0
#define NIEUWENHUIJZEN_FUDGE_FACTOR
#define VINK_SOLAR_METALLICITY 0.019

#define WIND_PROTOTYPE_ARGS                     \
    const double mass,                          \
	const double core_mass,			\
	const double luminosity,                \
	const double radius,                    \
	const double roche_lobe_radius,		\
	const double metallicity,               \
	const double omega,                     \
	const Stellar_type stellar_type,        \
	struct star_t * const star,             \
	struct stardata_t * const stardata

#define WIND_CALL_ARGS  mass,			\
	core_mass,				\
	luminosity,				\
	radius,					\
	roche_lobe_radius,			\
	metallicity,				\
	omega,					\
	stellar_type,				\
	star,					\
	stardata

#define MDOT_MS 0
#define MDOT_GB (MDOT_MS+1)
#define MDOT_AGB (MDOT_GB+1)
#define MDOT_WR (MDOT_AGB+1)
#define MDOT_LBV (MDOT_WR+1)
#define MDOT_OTHER (MDOT_LBV+1)
#define MDOT_COUNT (MDOT_OTHER+1)

#define MDOT_FAC_CRAP 0
#define MDOT_FAC_ROTATION (MDOT_FAC_CRAP+1)
#define MDOT_FAC_COUNT (MDOT_FAC_ROTATION+1)


#endif // WIND_MACROS_H
