#include "wind.h"

/* 
 * LBV-like mass loss beyond the Humphreys-Davidson limit.
 */

double Constant_function_if_no_debug wind_LBV(WIND_PROTOTYPE_ARGS)
{
    double mdot_LBV=0.0;
    const double x = 1.0E-5*radius*sqrt(luminosity) - 1.0;

    if(stellar_type>=HERTZSPRUNG_GAP && 
       luminosity>LBV_LUMINOSITY && 
       x>0.0)
    {         
        mdot_LBV = 0.10*Pow3(x)*(luminosity/LBV_LUMINOSITY-1.0);
    }
    else
    {
        mdot_LBV = 0.0;
    }

    Dprint("mdotLBV check stellar_type=%d radius=%g lum=%g hence x=(10^-5*R*sqrt(L)-1.0)=%g -> mdot_LBV=%g\n",
           stellar_type,radius,luminosity,x,mdot_LBV);

    return(mdot_LBV);
}
