#include "wind.h"

double wind_Hurley2002(WIND_PROTOTYPE_ARGS)
{
    double mdot_wind;
    double mdot[MDOT_COUNT]; // different wind mass losses
    if(stellar_type<HeWD)
    {
        /* calculate contributions from different types of mass loss */
        mdot[MDOT_MS]  = 0.0;
        mdot[MDOT_GB] = wind_GB(WIND_CALL_ARGS);
        mdot[MDOT_AGB] = wind_AGB(WIND_CALL_ARGS);
        mdot[MDOT_WR] = wind_WR(WIND_CALL_ARGS);
        mdot[MDOT_OTHER]  = wind_other(WIND_CALL_ARGS);
        mdot[MDOT_LBV] = wind_LBV(WIND_CALL_ARGS);

        Dprint("mdot%d (premod): M=%g Mc=%g : MS=%d=%g GB=%d=%g AGB=%d=%g WR=%d=%g OTHER=%d=%g LBV=%d=%g : ",
               star->starnum,
               mass,
               core_mass,
               MDOT_MS,mdot[MDOT_MS],
               MDOT_GB,mdot[MDOT_GB],
               MDOT_AGB,mdot[MDOT_AGB],
               MDOT_WR,mdot[MDOT_WR],
               MDOT_OTHER,mdot[MDOT_OTHER],
               MDOT_LBV,mdot[MDOT_LBV]
            );
 
        /* apply aritificial multiplicative factors */
        wind_multiplicative_factors(mdot,WIND_CALL_ARGS);

        /* enhancement factors (CRAP, rotation, etc) */
        double mult=wind_enhancement_factors(mdot,WIND_CALL_ARGS);

        /* choose the mass loss rate to use */
        mdot_wind = max_from_list(5,
                                  mdot[MDOT_MS],
                                  mdot[MDOT_GB],
                                  mdot[MDOT_AGB],
                                  mdot[MDOT_WR],
                                  mdot[MDOT_OTHER])
            + mdot[MDOT_LBV];
        
        /* use global multiplication factor (see above) */
        mdot_wind *= mult;

        /* limit to the dynamical rate of the envelope */
        double mdot_dyn = Max(0.1*star->mass, star->mass - star->core_mass) /
            Max(1e-20,dynamical_timescale_envelope(star));

        /* 
         * limit to 10% wind mass loss change in any one timestep
         * 
         * Normally, this is never required. But if there is a merger
         * between a massive helium star and a main sequence star, a 
         * massive CHeB star is formed. The LBV mass loss rate can then
         * lead to very rapid mass loss which exceeds 100% per time step.
         * Even 10% is still fast, but at least manageable by the 
         * evolution algorithm.
         */
        double mdot_tenpc = star->mass * 0.1 / stardata->model.dt; 

        mdot_wind = Min3(mdot_wind,
                         mdot_dyn,
                         mdot_tenpc);
    }
    else
    {
        /*
         * no mass loss for remnants
         */
        mdot_wind = 0.0;
    }
    return mdot_wind;
}
