#include "wind.h"

double Pure_function wind_GB(WIND_PROTOTYPE_ARGS)
{
    double mdot_GB=0.0;

    /*
     * "first giant branch" winds: AGB winds are dealt with in the AGB
     * function: all other potentially giant stars have this wind applied
     */

    if((stellar_type==HERTZSPRUNG_GAP)||
       (stellar_type==GIANT_BRANCH)||
       (stellar_type==CHeB)||
       (stellar_type>=HeMS))
    {
#ifdef PN_FAST_WIND
        if((stellar_type==GIANT_BRANCH)&&(mass-core_mass < PN_FAST_WIND_DM_GB))
        {
            mdot_GB = PN_FAST_WIND_MDOT_GB;
        }
        else
        {
#endif
            double reimers=radius*luminosity/mass;
            if(stardata->preferences->gbwind==GB_WIND_REIMERS)
            {
                /* 'Reimers' mass loss */
                mdot_GB = stardata->preferences->gb_reimers_eta * 4.0E-13 * reimers;
            }
            else if(stardata->preferences->gbwind==GB_WIND_SCHROEDER_CUNTZ_2005)
            {
                /* Use Schroeder and Cuntz 2005 variant of Reimers */ 

                /* gratio = g_sun / g_star */
                double gratio=radius/sqrt(mass);
                double teff = 1000.0*pow((1130.0*luminosity/Pow2(radius)),0.25);
                mdot_GB = stardata->preferences->gb_reimers_eta * 8e-14 * reimers * Pow3p5(teff/4000) * (1.0+gratio/4300.0);
            }
#ifdef PN_FAST_WIND
        }
#endif
    }
    
    return mdot_GB;
}
