#include "wind.h"

/*
 * Calculate wind velocity (in cgs units)
 */

double Pure_function vwind(WIND_PROTOTYPE_ARGS)
{
    double vw ; // returned
    
    /* wind velocity by stellar type */
    if(AGB(stellar_type))
    { 
        /* 
         * EAGB and TPAGB stars: 
         * fit from Vassiliadis and Wood 1993
         */
        double p0 = Min(pow(10.0,(-2.07 - 0.90*log10(mass) + 1.940*log10(radius))),2000.0);
        vw = Max(1.0e5 * (-13.5+0.056*p0),0.0) ; 
    }
    else if(POST_NUCLEAR_BURNING(stellar_type))
    {
        /* 
         * no nuclear burning : assume no (significant) wind,
         * e.g. white dwarfs, neutron stars, black holes.
         */
        vw = 0.0;
    }
    else
    {
        /* 
         * All other nuclear-burning stars:
         * main sequence, first giant branch, core/shell helium stars.
         *
         * The multiplier is a free parameter, set to 1/8 by Hurley 
         * et al. (2002).
         */
        vw = sqrt(2.0*GRAVITATIONAL_CONSTANT*
                  stardata->preferences->vwind_multiplier * 
                  mass*M_SUN/(radius*R_SUN)); 
    }

    return vw;
}
