#include "../binary_c.h"
#include "timestep.h"

void timestep_other(Timestep_prototype_args)
{
    /*
     * Timestep for stellar types that don't have their 
     * own function, e.g. remnants (WD, NS, BH) and 
     * MASSLESS_REMNANTs. These stars live forever, 
     * so there shouldn't be a stellar evolutionary 
     * reason for the timestep to be short, except that
     * you might want to resolve (say) the WD cooling 
     * track (this should be done elsewhere).
     */

    if(Use_timestep(DT_LIMIT_OTHER_STELLAR_TYPES))
    {
        Set_timestep(*dt,
                     stardata->preferences->timestep_multipliers[DT_LIMIT_OTHER_STELLAR_TYPES],
                     star,
                     DT_LIMIT_OTHER_STELLAR_TYPES);
    }

    /* these stars live forever */
    *time_remaining = LONG_TIME_REMAINING;

#ifdef HRDIAG
    stardata->model.hrdiag_dt_guess = (star->luminosity > 0.1) ? 0.01 : 100.0;
#ifdef HRDIAG_DTLOG
    printf("HRDT (deltat) remnant %g\n",stardata->model.hrdiag_dt_guess);
#endif
    HRDIAG_DT_NEGATIVE_CHECK;
#endif
}
