#include "../binary_c.h"

void timestep_fixed_timesteps(Timestep_prototype_args)
{
    /*
     * Limit the timestep according to the various
     * fixed timestep algorithms, as set in setup_fixed_timesteps.c
     */
    int i;
    for(i=0;i<NUMBER_OF_FIXED_TIMESTEPS;i++)
    {
        struct binary_c_fixed_timestep_t * t = stardata->model.fixed_timesteps + i;
            
        if(t->enabled == TRUE)
        {
            const double T = t->logarithmic ? log10(stardata->model.time) : stardata->model.time;
            if(Less_or_equal(T,t->end))
            {
                double dtlim;
                if(timestep_fixed_trigger(stardata,i))
                {
                    /*
                     * Triggered on this timestep : limit next timestep
                     * to exactly this trigger's step.
                     */
                    dtlim = t->logarithmic ? (pow(10.0,T + t->step) - stardata->model.time) : t->step;
                }
                else
                {
                    /* 
                     * Not triggered on this timestep : 
                     * the time to the next trigger limits the timestep.
                     */ 
                    dtlim = (t->logarithmic ? pow(10.0,t->next) : t->next) - stardata->model.time;
                }

                Dprint("Set dtlim = %30.20g : next time will be %30.20g : Times_are_equal? %s\n",
                       dtlim,
                       log10(stardata->model.time + dtlim),
                       Yesno(Times_are_equal(t->next,
                                             log10(stardata->model.time + dtlim)))
                    );
                
                Limit_timestep(*dt,dtlim,star,DT_LIMIT_FIXED_TIMESTEP);
            }
        }
    }
}
