#include "../binary_c.h"
#include "timestep.h"

void timestep_MS(Timestep_prototype_args)
{
#ifdef BINT

    /*
     * Estimate main sequence timestep based on rate of central hydrogen
     * exhaustion and main sequence lifetime
     */
    double tms_deriv = star->bint.XHc /
        Max(1e-50,fabs(star->derivative[DERIVATIVE_STELLAR_CENTRAL_HYDROGEN]));
    double tms_mass = BINT_MS_lifetime(stardata,star); 
    double tms = Min(tms_mass, tms_deriv) * 1e-6;

    if(Use_timestep(DT_LIMIT_MS))
    {
        Set_timestep(*dt,stardata->preferences->timestep_multipliers[DT_LIMIT_MS]*tms,star,DT_LIMIT_MS);
    }
    *time_remaining = tms_mass - star->age;
#else
    
    if(Use_timestep(DT_LIMIT_MS))
    {
        Set_timestep(*dt,stardata->preferences->timestep_multipliers[DT_LIMIT_MS]*tm,star,DT_LIMIT_MS);
    }
    *time_remaining = tm - age;

#ifdef HRDIAG
    /*
     * smoother MS timestep:
     *
     * at early times ~ 10% of the MS lifetime
     * at late times ~ 10% of the HG lifetime
     * This resolves the MS->HG transition.
     */
    {
        double x=stardata->model.time / tm;
        double dt_ms=HRDIAG_FRAC*tm;
        double dt_hg=HRDIAG_FRAC*(tscls[1]-tm);
        double f=1.0/(1.0+pow(1e-10,0.8-x));
        stardata->model.hrdiag_dt_guess = dt_hg + dt_ms*f;
    }
#ifdef HRDIAG_DTLOG
    printf("HRDT (deltat) MS %g\n",stardata->model.hrdiag_dt_guess);
#endif
    HRDIAG_DT_NEGATIVE_CHECK;
#endif

#ifdef PRE_MAIN_SEQUENCE
    /* resolve the pre-Main sequence */
    if(Use_timestep(DT_LIMIT_PREMS) &&
       stardata->preferences->pre_main_sequence == TRUE)
    {
        double dtPMS = 1e-6 * preMS_lifetime(star->mass); // Myr
        if(stardata->model.time < 2.0*dtPMS)
        { 
            Limit_timestep(*dt,stardata->preferences->timestep_multipliers[DT_LIMIT_PREMS]*dtPMS,star,DT_LIMIT_PREMS);
        }
    }
#endif

#ifdef SLOW_DOWN_PREROCHE_MS
    if(stardata->model.sgl == FALSE)
    {
        double rr = star->radius / star->roche_radius;
        Dprint("RR = %g from R = %g, RL = %g (t = %g)\n",
               rr,
               star->radius,
               star->roche_radius,
               stardata->model.time);
        const double flim = 1e-2;
        const double k = 2.0; // larger -> smaller timestep
        const double fdt =
            rr<0.5 ? 1.0 :
            rr<1.0 ? (Min(1.0, Max(flim,pow(1.0/rr-1.0,k))))
            : flim;
        double newdt = *dt * fdt;
        Limit_timestep(*dt,newdt,star,DT_LIMIT_PREROCHE_MS);
        Dprint("prerocheMS star=%d rr=%g fdt=%g\n",
               star->starnum,
               rr,
               fdt);
    }    
#endif // SLOW_DOWN_PREROCHE_EAGB

#endif //BINT

}
