#include "../binary_c.h"
#include "timestep.h"

void timestep_HeHG_HeGB(Timestep_prototype_args)
{
#ifdef BSE
    double dtt = age<tscls[6] ? (tscls[4] - age) : (tscls[5] - age);
    
    if(Use_timestep(DT_LIMIT_HeHG_GB))
    {
        Set_timestep(*dt,stardata->preferences->timestep_multipliers[DT_LIMIT_HeHG_GB]*dtt,star,DT_LIMIT_HeHG_GB);
    }

#ifdef HRDIAG
    stardata->model.hrdiag_dt_guess = HRDIAG_FRAC* dtt;
#ifdef HRDIAG_DTLOG
    printf("HRDT (deltat) He Post-MS %g\n",stardata->model.hrdiag_dt_guess);
#endif
    HRDIAG_DT_NEGATIVE_CHECK;
#endif
    *time_remaining = tn - age;
#endif//BSE
}
