#include "../binary_c.h"
#include "timestep.h"

void timestep_HG(Timestep_prototype_args)
{
#ifdef BSE
    double dtt= 0.1*(tscls[T_BGB] - tm);
    if(Use_timestep(DT_LIMIT_HG))
    {
        Set_timestep(*dt,stardata->preferences->timestep_multipliers[DT_LIMIT_HG]*dtt,star,DT_LIMIT_HG);
    }
    *time_remaining = tscls[T_BGB] - age;

#ifdef HRDIAG
    stardata->model.hrdiag_dt_guess = HRDIAG_FRAC* dtt;
        
#ifdef HRDIAG_DTLOG
    printf("HRDT (deltat) HG %g\n",stardata->model.hrdiag_dt_guess);
#endif
    HRDIAG_DT_NEGATIVE_CHECK;
#endif

#ifdef SLOW_DOWN_PREROCHE_HG
    if(stardata->model.sgl == FALSE)
    {
        double rr=star->radius / star->roche_radius;
        if(Use_timestep(DT_LIMIT_PREROCHE_HG) && rr<1.0)
        {
            const double newdt = *dt * Min(1.0, Max(1e-2,Pow2(1.0/rr-1.0))) * stardata->preferences->timestep_multipliers[DT_LIMIT_PREROCHE_HG];
            Limit_timestep(*dt,newdt,star,DT_LIMIT_PREROCHE_HG);
        }
    }
#endif // SLOW_DOWN_PREROCHE_EAGB



    const double accretion_rate = Mdot_net(star);
    if(accretion_rate > 0.0)
    {
        /*
         * Use the accretion rate limit, not the 
         * stellar evolution limit if an AGB star is accreting.
         */
        *time_remaining = LONG_TIME_REMAINING;
    }

#endif//BSE
}

