#include "../binary_c.h"
#include "timestep.h"

void timestep_FGB(Timestep_prototype_args)
{
#ifdef BSE
    double dtt = (age<tscls[6] ? tscls[4] : tscls[5]) - age;
    if(Use_timestep(DT_LIMIT_FGB))
    {
        Set_timestep(*dt,stardata->preferences->timestep_multipliers[DT_LIMIT_FGB]*dtt,star,DT_LIMIT_FGB);
    }
#ifdef HRDIAG
    stardata->model.hrdiag_dt_guess = 0.1 * dtt;
#ifdef HRDIAG_DTLOG
    printf("HRDT (deltat) GB %g\n",stardata->model.hrdiag_dt_guess);
#endif
    HRDIAG_DT_NEGATIVE_CHECK;
#endif
    *time_remaining = Min(tscls[2],tn) - age;
    Dprint("Set time remaining from tscls[2]=%g, tn=%g, age=%g -> %g\n",
           tscls[2],
           tn,
           age,
           *time_remaining
        );


    double accretion_rate = Mdot_net(star);
    if(accretion_rate > 0.0)
    {
        /*
         * Use the accretion rate limit, not the 
         * stellar evolution limit if an AGB star is accreting.
         */
        *time_remaining = LONG_TIME_REMAINING;
    }
#endif//BSE
}
