#include "../binary_c.h"
#include "timestep.h"

void timestep_CHeB(Timestep_prototype_args)
{
#ifdef BSE
    if(Use_timestep(T_HE_BURNING))
    {
        Set_timestep(*dt,stardata->preferences->timestep_multipliers[DT_LIMIT_CHeB]*tscls[T_HE_BURNING],star,DT_LIMIT_CHeB);
    }
#ifdef HRDIAG
    stardata->model.hrdiag_dt_guess = HRDIAG_FRAC* tscls[T_HE_BURNING];
#ifdef HRDIAG_DTLOG
    printf("HRDT (deltat) CHeB %g\n",stardata->model.hrdiag_dt_guess);
#endif // HRDIAG_DTLOG
    HRDIAG_DT_NEGATIVE_CHECK;
#endif // HRDIAG

 
    double accretion_rate = Mdot_net(star);
    if(Is_zero(accretion_rate))
    {
        *time_remaining = 
            Min(tn,
                (tscls[T_HE_BURNING] + tscls[T_HE_IGNITION]))
            - age;

        /*
         * Make sure there's at least 1000 years
         * remaining
         */
        *time_remaining = Max(1e-3, *time_remaining);
    }
    else
    {
        /*
         * Accretion CHeB star has an unknown lifetime,
         * because it depends on the accretion timescale,
         * which is generally unknown. Assume the mass  
         * transfer rate timescale limiter will resolve 
         * the timescale.
         */
        *time_remaining = LONG_TIME_REMAINING;
    }
#endif
}
