#include "../binary_c.h"

void setup_fixed_timesteps(struct stardata_t * RESTRICT const stardata)
{
    struct binary_c_fixed_timestep_t * t =
        &stardata->model.fixed_timesteps[FIXED_TIMESTEP_YIELDS];

    
#if defined NUCSYN && defined NUCSYN_GCE
    /*
     * Yields/ensemble fixed timesteps : 
     * when NUCSYN and NUCSYN_GCE are enabled, 
     * use this by default, although allow it 
     * to be turned off on the command line.
     */
    if(stardata->preferences->use_fixed_timestep[FIXED_TIMESTEP_YIELDS] == TRUE)
    {
        t->enabled = TRUE;
        t->begin =
            stardata->preferences->yields_logtimes == TRUE ?
            log10(stardata->preferences->yields_startlogtime) :
            0.0;
        t->end =
            stardata->preferences->yields_logtimes == TRUE ?        
            log10(stardata->model.max_evolution_time) :
            stardata->model.max_evolution_time;
        t->step =
            stardata->preferences->yields_logtimes == TRUE ?
            stardata->preferences->yields_logdt :
            stardata->preferences->yields_dt;
        t->next = t->begin + t->step;
        t->logarithmic = stardata->preferences->yields_logtimes;
        t->final = TRUE;
        t->previous_trigger = t->previous_test = t->begin;
    }
    else
    {
        t->enabled = FALSE;
    }
#else
    /* disable */
    t->enabled = FALSE;
#endif


    /*
     * The test timestep outputs every 1Myr. It is disabled by default.
     */
    t = &stardata->model.fixed_timesteps[FIXED_TIMESTEP_TEST];
    if(stardata->preferences->use_fixed_timestep[FIXED_TIMESTEP_TEST] == TRUE)
    {
        t->enabled = FALSE;
        t->begin = 0.0;
        t->end = stardata->model.max_evolution_time;
        t->step = 1.0;
        t->next = t->begin + t->step;
        t->logarithmic = FALSE;
        t->final = TRUE;
        t->previous_trigger = t->previous_test = t->begin;
    }
    else
    {
        t->enabled = FALSE;
    }

    /*
     * Others should be put here...
     *
     * When you add another fixed timestep remember to set a macro
     * for it in timestep.h and increment the NUMBER_OF_FIXED_TIMESTEPS
     * appropriately.
     */
}
