#include "../binary_c.h"

void final_timing_output(struct stardata_t * stardata,
                         const ticks start_tick,
                         const int repeat)
{
    ticks end_tick = getticks();

    /* calculate clock ticks */
    ticks t = end_tick - start_tick;

#ifdef CPUFREQ
    /* calculate total run time in seconds */
    double runtime = (double)Timer_seconds(t) - stardata->warmup_timer_offset;

    Printf("Tick count %llu, ~ runtime = %g repeat=%d",
	   t,
	   runtime,
	   repeat);

    if(repeat>1)
    {
      /* calculate ticks per run */
      double ticks_per_run = ((double)t)/(double)repeat;
      
      /* hence calculate the time per run */
      double perrun = runtime/((double)repeat);
      
      Printf(" per run = %g : ticks per run %g ",
	     perrun,
	     ticks_per_run);
    }
    Printf("\n");
#else

    Printf("Tick count %llu (CPUFREQ undefined)\n",t);

#endif // CPUFREQ

    fflush(stdout);

}
