#include "../binary_c.h"

#if defined TIMER_PER_SYSTEM
void calc_ticks_timer(struct stardata_t * stardata,
                      ticks * start_tick,
                      Boolean *first)
{
    ticks end_tick=getticks();
                              
    /* calculate clock ticks */
    long int ticks=((long int)end_tick-(long int) (*start_tick));

    if(*first==FALSE)
    {
	/* 
	 * never output the first call to evolve_system(),
	 * this contains setup time which is spurious
	 */
#ifdef CPUFREQ
	/* calculate total run time */
	double runtime=((float)ticks)/(1e6*((float)CPUFREQ));
	Printf("Tick count %ld, ~ runtime = %g\n",ticks,runtime);
#else
	Printf("Tick count %ld (CPUFREQ undefined)\n",ticks);
#endif // CPUFREQ
	//fflush(stdout);
    }

    /* reset the ticker */
    *start_tick = getticks();
                
    *first = FALSE;   
}
#endif // TIMER_PER_SYSTEM
