#include "../binary_c.h"

#if defined NUCSYN && defined NUCSYN_SIGMAV_PRE_INTERPOLATE


void table_sigmav(struct store_t * store)
{
    
    /*
     * Pre-make a table of sigma-v values for interpolation, rather than 
     * calculate them each time
     */
    double t9,dt9; // temperature
    int i,j; 

    /* calculate sigmav_size, allow one extra element for the temperature */
    size_t sigmav_size = (size_t)(SIGMAV_SIZE+1);

    Reaction_rate * data =
        Malloc((size_t)
               sizeof(Reaction_rate)*(SIGMAV_SIZE+1)*NUCSYN_SIGMAV_INTERPOLATION_RESOLUTION);

    /*
     * Loop through t9 values and set the sigmav values
     */
    dt9=(NUCSYN_SIGMAV_INTERPOLATION_MAX-NUCSYN_SIGMAV_INTERPOLATION_MIN)/
        (double)(NUCSYN_SIGMAV_INTERPOLATION_RESOLUTION-1);
    i=0;

    
    for(t9=NUCSYN_SIGMAV_INTERPOLATION_MIN;
        t9<=NUCSYN_SIGMAV_INTERPOLATION_MAX+TINY;
        t9+=dt9)
    {
        /* pointer to the sigmav array to be set */
        Reaction_rate *p = data + i * sigmav_size;
        i++;
        double logT=log10(t9);

        /* set the first element to t9 */
#ifdef NUCSYN_SIGMAV_INTERPOLATE_LOGT9
        *p = logT;
#else
        *p = t9;   
#endif
        nucsyn_set_sigmav(NULL,
                          store,
                          -(logT+9.0), // want log10(T)
                          p+1 // fill at next element
#ifdef NUCLEAR_REACTION_RATE_MULTIPLIERS
                          ,NULL // no multipliers!
#endif
#ifdef RATES_OF_AMANDA_NE22PG_FIX
                          /* this should be fixed! */
                          ,FALSE
#endif
            );

#ifdef NUCSYN_SIGMAV_INTERPOLATE_LOGSIGMAV
        /* convert sigmav to log10(sigmav) */
        for(j=1;j<SIGMAV_SIZE+1;j++)
        {
            *(p+j)=log10(*(p+j));
        }
#endif
    }
    
    NewDataTable_from_Pointer(
        data,
        store->sigmav,
        1,
        SIGMAV_SIZE,
        NUCSYN_SIGMAV_INTERPOLATION_RESOLUTION
        );

}


#endif
