
#include "../binary_c.h"

/*
 * Include BSE tables
 */

void table_BSE(struct store_t * RESTRICT const store)
{ 

#ifdef USE_BSE_MS_LR
#include "BSE_MS_LR.h"

    NewDataTable_from_Array(
        TABLE_BSE_MS_LR_DATA,
        store->BSE_MS_LR,
        3,
        2,
        TABLE_BSE_MS_LR_LINES);
    
#endif

#ifdef USE_BSE_TIMESCALES_H
#include  "BSE_TIMESCALES_H.h"

#define WIDTH (TSCLS_ARRAY_SIZE + LUMS_ARRAY_SIZE + GB_ARRAY_SIZE)
    NewDataTable_from_Array(
        TABLE_BSE_TIMESCALES_H_DATA,
        store->BSE_TIMESCALES_H,
        2,
        WIDTH,
        TABLE_BSE_TIMESCALES_H_LINES);
    
#endif //USE_BSE_TIMESCALES_H
    
}
