#pragma once
#ifndef SUPERNOVA_PROTOTYPES_H
#define SUPERNOVA_PROTOTYPES_H
void supernova(struct stardata_t * const stardata,
               struct star_t * const star);
void supernova_kick(struct stardata_t * const stardata,
                    struct stardata_t * const pre_explosion_stardata,
                    struct star_t * const star,
                    struct star_t * const pre_explosion_star);

double monte_carlo_kick(struct star_t * const star,
                        struct star_t * const pre_explosion_star,
                        const double m1n,
                        const double m1,
                        const double m2,
                        double * const eccentricity,
                        double * const separation,
                        double * const jorb,
                        struct stardata_t * const stardata,
                        struct stardata_t * const pre_explosion_stardata);


void set_kick_velocity(struct stardata_t * const stardata,
                       struct star_t * const exploder,
                       struct kick_system_t * const kick_system,
                       const int kick_distribution,
                       const double kick_dispersion,
                       const double kick_companion);

void setup_binary_at_kick(struct stardata_t * const stardata,
                          const double separation,
                          const double eccentricity,
                          const double system_mass,
                          struct kick_system_t * const kick_system);

void set_new_orbit(struct stardata_t * const stardata,
                   struct stardata_t * const pre_explosion_stardata,
                   struct star_t * const pre_explosion_star,
                   struct star_t * const exploder,
                   struct star_t * const companion,
                   struct kick_system_t * const kick_system,
                   char ** const strings,
                   const int kick_distribution,
                   const double kick_dispersion,
                   const double kick_companion,
                   const double m1,
                   const double m1n,
                   double m2,
                   double * const jorb,
                   double * const separation,
                   double * const eccentricity);

void tauris_takens_orbit(struct stardata_t * const stardata,
                         struct stardata_t * const pre_explosion_stardata,
                         struct star_t * const pre_explosion_star,
                         struct star_t * const exploder,
                         struct star_t * const companion,
                         struct kick_system_t * const kick_system,
                         char ** const strings,
                         const int kick_distribution,
                         const double kick_dispersion,
                         const double kick_companion);


double Pure_function ejection_speed(const struct star_t * RESTRICT const star);

struct star_t * new_supernova(struct stardata_t * const stardata,
                              struct star_t * const star,
                              struct star_t * const companion,
                              struct star_t * const newstar);
void free_supernova(struct stardata_t * const stardata,
                    struct star_t * const star);

double Pure_function supernova_kinetic_energy(const struct star_t * RESTRICT const star);
double Pure_function supernova_luminous_energy(const struct star_t * RESTRICT const star);
double Pure_function supernova_momentum(const struct star_t * RESTRICT const star);
double Pure_function supernova_ejecta_velocity(const struct star_t * RESTRICT const star);

Event_handler_function supernova_event_handler(void * const eventp,
                                               struct stardata_t * const stardata,
                                               void * data);
Event_handler_function supernova_erase_event_handler(void * const eventp,
                                                     struct stardata_t * const stardata,
                                                     void * data);


double Pure_function ns_bh_mass(const double m,
                                const double mc,
                                struct stardata_t * RESTRICT const stardata,
                                const struct star_t * RESTRICT const star);

#endif // SUPERNOVA_PROTOTYPES_H

