#include "../binary_c.h"

double Pure_function supernova_kinetic_energy(const struct star_t * RESTRICT const star)
{
    /*
     * Estimate the kinetic energy of a supernova
     * in erg
     */
    double energy;
    
    switch(star->SN_type)
    {
    case SN_IA_He:
    case SN_IA_ELD:
    case SN_IA_CHAND:
    case SN_IA_He_Coal:
    case SN_IA_CHAND_Coal:
    case SN_IA_Hybrid_HeCOWD:
    case SN_IA_Hybrid_HeCOWD_subluminous:
        energy = 1.0 * FOE;
        break;
    case SN_IBC:
    case SN_II:
    case SN_GRB_COLLAPSAR:
        energy = 1.0 * FOE;
        break;
    default:
        energy = 0.0;
        break;
    };

    return energy;
}
