#include"../binary_c.h"

/*
 * Event handling function for supernovae
 */

Event_handler_function supernova_event_handler(void * const eventp,
                                               struct stardata_t * const stardata,
                                               void * data)
{
    //struct binary_c_event_t * event = eventp;
    Dprint("catch events at %20.12g : SN types %d %d : new_supernova structs %p %p\n",
           stardata->model.time,
           stardata->star[0].SN_type,
           stardata->star[1].SN_type, 
           stardata->star[0].new_supernova,
           stardata->star[1].new_supernova
        );
    Star_number k;
    Starloop(k)
    { 
        SETstar(k);

        /* 
         * Supernovae and kicks
         */
        if(star->SN_type != SN_NONE)
        {
            stardata->model.supernova = TRUE;
            Dprint("Caught supernova in star %d of type %d M1=%g M2=%g\n",
                   star->starnum,
                   star->SN_type,
                   stardata->star[0].mass,
                   stardata->star[1].mass
                );

            /*
             * Call the supernova function to handle
             * kicks, mass change, yields, etc.
             */
            supernova(stardata,star);
            Dprint("after supernova\n");

            /*
             * Check for broken system
             */
            if(System_is_single)
            {
                stardata->model.sgl = TRUE;
            }
            else
            {
                /* set the new period from the post-SN system mass */ 
                stardata->common.orbit.period =
                    Is_zero(stardata->common.orbit.separation) ? 0.0 :
                    ((stardata->common.orbit.separation/AU_IN_SOLAR_RADII)
                     *sqrt(stardata->common.orbit.separation/(AU_IN_SOLAR_RADII*(stardata->star[0].mass + stardata->star[1].mass))));

                /* and the orbital angular frequency */ 
                stardata->common.orbit.angular_frequency = 
                    Is_zero(stardata->common.orbit.separation) ? 0.0 :
                    (TWOPI/stardata->common.orbit.period);
            }
        }
    }

    return NULL;
}
