#include"../binary_c.h"

/*
 * Event handling function for supernovae: this deals with
 * an erase action
 */

Event_handler_function supernova_erase_event_handler(void * eventp,
                                                     struct stardata_t * stardata,
                                                     void * data)
{
    Dprint("SN erase event handler\n");
    Star_number k;
    Starloop(k)
    { 
        SETstar(k);
        if(star->SN_type != SN_NONE)
        {
            Dprint("call free_supernova on star %d SN type %d\n",
                   star->starnum,
                   star->SN_type);
            free_supernova(stardata,star);
        }
    }
    return NULL;
}
    
