#include "../binary_c.h"

double Pure_function supernova_ejecta_velocity(const struct star_t * RESTRICT const star)
{
    /*
     * SN ejection velocity, km/s
     */
    double v;
    switch(star->SN_type)
    {
    case SN_IA_He:
    case SN_IA_ELD:
    case SN_IA_CHAND:
    case SN_IA_He_Coal:
    case SN_IA_CHAND_Coal:
        v = 1e4;
        break;
    case SN_IBC:
    case SN_II:
    case SN_GRB_COLLAPSAR:
        v = 1e4;
        break;
    default:
        v = 0.0;
        break;
    };

    return v;
}
