#pragma once
#ifndef SN_H
#define SN_H

/* 
 * Header file for supernova-related data
 *
 * Includes integers defining SN types (SN_*)
 * and kick algorithms
 */

#define LOG_Ia
#define LOG_Ibc_II

#define SUPERNOVAE_LOG_FILENAME (stardata->preferences->sn_dat_filename)
#define DEFAULT_SN_DAT_FILENAME "/tmp/sn.dat-rgi"


/* Supernova types */
#define SN_NONE 0
#define SN_IA_He 1
#define SN_IA_ELD 2
#define SN_IA_CHAND 3
/*
 * SN_IA_CHAND gets converted according to the stellar type of the progenitor
 * and might be AIC or IA CO
 */
#define SN_AIC 4
#define SN_ECAP 5
#define SN_IA_He_Coal 6
#define SN_IA_CHAND_Coal 7
#define SN_NS_NS 8
#define SN_GRB_COLLAPSAR 9
#define SN_HeStarIa 10 
#define SN_IBC 11
#define SN_II 12
#define SN_IIa 13
#define SN_WDKICK 14
#define SN_TZ 15
#define SN_AIC_BH 16
#define SN_BH_BH 17
#define SN_BH_NS 18
#define SN_IA_Hybrid_HeCOWD 19
#define SN_IA_Hybrid_HeCOWD_subluminous 20
#define NUM_SN_TYPES 21
#define NUM_SN_STRINGS NUM_SN_TYPES

#define SN_STRING_LENGTH ((size_t)30)
#define SN_STRINGS {                            \
        "None",/*0*/                            \
        "HeIa",                                 \
        "ELDIa",                                \
        "ChandIa",                              \
        "AIC",                                  \
        "ECAP", /*5*/                           \
        "He_Coal",                              \
        "CHAND_Coal",                           \
        "GRB_NS_NS",                            \
        "GRB_Collapsar",                        \
        "HeStarIa", /*10*/                      \
        "Ib/c",                                 \
        "II",                                   \
        "IIa",                                  \
        "WDKICK",                               \
        "TZ", /*15*/                            \
        "AIC_BH",                               \
        "BH_BH",                                \
        "BH_NS",                                \
        "IA_Hybrid_HeCOWD",                     \
        "IA_Hybrid_HeCOWD_subluminous"/*20*/    \
    }

#define SN_String(T) (                                  \
        (T)==SN_NONE ? "None" :                         \
        (T)==SN_IA_He ? "IaHe" :                        \
        (T)==SN_IA_ELD ? "IaELD" :                      \
        (T)==SN_IA_CHAND ? "IaCHAND" :                  \
        (T)==SN_AIC ? "AIC" :                           \
        (T)==SN_ECAP ? "ECAP" :                         \
        (T)==SN_IA_He_Coal ? "IaHeCoal" :               \
        (T)==SN_IA_CHAND_Coal ? "IaCHANDCoal" :         \
        (T)==SN_NS_NS ? "NSNS" :                        \
        (T)==SN_GRB_COLLAPSAR ? "GRBCollapsar" :        \
        (T)==SN_HeStarIa ? "HeStarIa" :                 \
        (T)==SN_IBC ? "Ibc" :                           \
        (T)==SN_II ? "II" :                             \
        (T)==SN_WDKICK ? "WDKick" :                     \
        (T)==SN_TZ ? "TZ" :                             \
        (T)==SN_AIC_BH ? "AICBH" :                      \
        (T)==SN_BH_BH ? "BHBH" :                        \
        (T)==SN_BH_NS ? "BHNS" :                        \
        (T)==SN_IA_Hybrid_HeCOWD ? "IaHybridHeCOWD" :   \
        "Unknown"                                       \
        )

/* Temporal positions */
#define PRE_SN 0
#define POST_SN 1

/*
 * Macros for detecting stellar type
 */

#define SN_TYPE_IS_IA(TYPE) (                   \
        (TYPE)==SN_IA_He ||                     \
        (TYPE)==SN_IA_ELD ||                    \
        (TYPE)==SN_IA_CHAND ||                  \
        (TYPE)==SN_IA_He_Coal ||                \
        (TYPE)==SN_IA_CHAND_Coal ||             \
        (TYPE)==SN_IA_Hybrid_HeCOWD             \
        )

#define SN_TYPE_IS_CORE_COLLAPSE(TYPE) (        \
        (TYPE)==SN_II ||                        \
        (TYPE)==SN_IBC                          \
        )


/*
 * SN/WD kick distributions :
 *
 * fixed e.g. Izzard et al 2010 (Barium star kicks of a fixed velocity)
 * maxwellian e.g. Hansen and Phinney 1997 using Hurley et al 2002 algorithm
 * custom : any function you like (see monte_carlo_kick.c) 
 */
#define kick_dist int
#define KICK_VELOCITY_FIXED 0
#define KICK_VELOCITY_MAXWELLIAN 1
#define KICK_VELOCITY_CUSTOM 2

/* when do we kick the WD ? */
#define WD_KICK_END_AGB 0
#define WD_KICK_FIRST_RLOF 1
#define WD_KICK_AT_GIVEN_PULSE 2
#define WD_KICK_AT_EVERY_PULSE 3


/*
 * Post-SN orbit calculation method
 */
#define POST_SN_ORBIT_BSE 0
#define POST_SN_ORBIT_TT98 1

/*
 * SN impulse mechanisms
 */
#define SN_IMPULSE_NONE 0
#define SN_IMPULSE_LIU2015 1
#define SN_IMPULSE_WHEELER1975 2

/*
 * Kick directions
 */
#define KICK_RANDOM 0 
#define KICK_STRAIGHT_UP 1
#define KICK_FORWARD 2
#define KICK_BACKWARD 3
#define KICK_INWARD 4
#define KICK_OUTWARD 5

#endif /* SN_H */
