#include "../binary_c.h"

/*
 * Free the memory associated with a new supernova.
 *
 * This can be done either after a supernova has been caught, or after 
 * common envelope evolution (which should never really give 
 * a supernova).
 */

void free_supernova(struct stardata_t * const stardata,
                    struct star_t * const star)
{
    Dprint("free_supernova: SN star=%p star->new_supernova=%p star->new_supernova->new_stellar_structure=%p\n",
           star,
           star->new_supernova,
           star->new_supernova ? star->new_supernova->new_stellar_structure : NULL
        );
    if(star!=NULL &&
       star->new_supernova!=NULL)
    {
        Dprint("Free star->new_supernova->new_stellar_structure = %p\n",
               star->new_supernova->new_stellar_structure);
        Safe_free(star->new_supernova->new_stellar_structure);
        Dprint("post-free now %p\n",
               star->new_supernova->new_stellar_structure);
            
        Dprint("Free star->new_supernova->new_companion_structure = %p\n",
               star->new_supernova->new_companion_structure);
        Safe_free(star->new_supernova->new_companion_structure);
        Dprint("post-free now %p\n",
               star->new_supernova->new_companion_structure);
            

        Dprint("Free star->new_supernova = %p\n",
               star->new_supernova);
        Safe_free(star->new_supernova);
        Dprint("post-free now %p\n",
               star->new_supernova);
    }

} 

