#include "../binary_c.h"


void string_array_to_double_array(char ** RESTRICT const strings,
                                  double ** RESTRICT const doubles,
                                  const size_t n)
{
    /*
     * Convert strings array to array of doubles.
     *
     * You need to free *doubles when you are finished
     * with it.  
     */
    *doubles = Malloc(n*sizeof(double*));
    size_t i;
    for(i=0;i<n;i++)
    {
        (*doubles)[i] = strtod(strings[i],NULL);
    }
}
