
#ifndef STELLAR_TIMESCALES_PROTOTYPES_H
#define STELLAR_TIMESCALES_PROTOTYPES_H

#include "../binary_c_parameters.h"
#ifdef BSE

#include "../binary_c_structures.h"
void stellar_timescales(const Stellar_type stellar_type,
                        double mass, /** stellar mass **/
                        double mt,
                        double * RESTRICT const tm,
                        double * RESTRICT const tn,
                        double * RESTRICT const timescales,
                        double * RESTRICT const luminosities,
                        double * RESTRICT const GB,
                        struct stardata_t * RESTRICT const stardata,
                        struct star_t * RESTRICT const star);

void stellar_timescales_low_mass_AGB(const double mass,
                                     const double mt,
                                     const double mcbagb,
                                     const double ip,
                                     const double iq,
                                     const double mp,
                                     const double mq,
                                     double * RESTRICT tn,
                                     const double * RESTRICT const timescales,
                                     const double * RESTRICT const luminosities,
                                     const double * RESTRICT const GB,
                                     const double * giant_branch_parameters,
                                     const double * metallicity_parameters,
                                     struct star_t * star,
                                     struct stardata_t * stardata);
void stellar_timescales_massive_AGB_tn(const Stellar_type stellar_type,
                                       const double mass,
                                       const double mt,
                                       const double mcbagb,
                                       const double ip,
                                       const double iq,
                                       const double mp,
                                       const double mq,
                                       double *tn,
                                       const double * RESTRICT const timescales,
                                       const double * RESTRICT const GB,
                                       struct star_t * RESTRICT const star);


void stellar_timescales_GB_parameters(const double mass,
                                      const double mp6,
                                      double * RESTRICT const GB);

int stellar_timescales_post_HG(const double tbagb,
                               const double ip,
                               const double iq,
                               const double GBp,
                               const double GBq,
                               const double mp,
                               const double mq,
                               const double mcbagb,
                               const double phase_start_mass,
                               const double mass,
                               double * tn,
                               double * GB,
                               double * timescales,
                               double * luminosities,
                               const double * const giant_branch_parameters,
                               const double * const metallicity_parameters,
                               struct stardata_t * const stardata,
                               struct star_t * const star,
                               const Stellar_type stellar_type);
void stellar_timescales_high_mass_GB(const double mass,
                                     const double mp2,
                                     double * const timescales,
                                     double * const luminosities,
                                     const double * RESTRICT const giant_branch_parameters);
void stellar_timescales_helium_stars(const double mass,
                                     const double mt,
                                     double *tm,
                                     double *tn,
                                     double * RESTRICT const timescales,
                                     double * RESTRICT const luminosities,
                                     double * RESTRICT const GB,
                                     struct stardata_t * const stardata,
                                     struct star_t * const star);

int stellar_timescales_hydrogen_stars(const double mass, 
                                      const double mt,
                                      double * RESTRICT tm, 
                                      double * RESTRICT tn, 
                                      double * RESTRICT const timescales, 
                                      double * RESTRICT const luminosities, 
                                      double * RESTRICT const GB,
                                      struct stardata_t * const stardata,
                                      struct star_t * const star,
                                      const Stellar_type stellar_type);
void stellar_timescales_low_mass_GB(const double GBp,
                                    const double GBq,
                                    const double ip,
                                    const double iq,
                                    const double mass,
                                    double * RESTRICT const timescales,
                                    double * RESTRICT const luminosities,
                                    double * RESTRICT const GB,
                                    const double * RESTRICT const giant_branch_parameters,
                                    const double * RESTRICT const metallicity_parameters,
                                    struct stardata_t * stardata);
#endif // BSE
#endif// STELLAR_TIMESCALES_PROTOTYPES_H
