#include "../binary_c.h"
#ifdef BSE
void stellar_timescales_massive_AGB_tn(const Stellar_type stellar_type,
                                       const double mass,
                                       const double mt,
                                       const double mcbagb,
                                       const double ip,
                                       const double iq,
                                       const double mp,
                                       const double mq,
                                       double *tn,
                                       const double * RESTRICT const timescales,
                                       const double * RESTRICT const GB,
                                       struct star_t * RESTRICT const star)
{ 
    double mc1 = mcbagb;
    double mcmax;
    if(stellar_type==TPAGB)
    {
        /*
         * artificially stop mc1 from growing too large
         *
         * lambda is computed (and saved) by the stellar evolution
         * algorithm, so use it if it is non-zero, otherwise the BSE
         * approximation.
         */
        double lambda = 
            Is_zero(star->lambda_3dup) ? star->lambda_3dup : 
            Min(0.9, 0.3 + 1e-3 * Pow5(mass));
        
        mcmax = (mt - lambda*mc1)/(1.0 - lambda);
    }
    else
    {
        mcmax = mcbagb;
    }

    if(Less_or_equal(mc1,GB[GB_Mx]))
    {
	*tn = timescales[T_TPAGB_TINF_1] - (ip/(GB[GB_A_H_HE]*GB[GB_D]))*pow(mcmax,mp);
    }
    else
    {
        *tn = timescales[T_TPAGB_TINF_2] - (iq/(GB[GB_A_H_HE]*GB[GB_B]))*pow(mcmax,mq);
    }

}
#endif
