
#include "../binary_c.h"

#ifdef BSE
void stellar_timescales_low_mass_GB(const double GBp,
                                    const double GBq,
                                    const double ip,
                                    const double iq,
                                    const double mass,
                                    double * RESTRICT const timescales,
                                    double * RESTRICT const luminosities,
                                    double * RESTRICT const GB,
                                    const double * RESTRICT const giant_branch_parameters,
                                    const double * RESTRICT const metallicity_parameters,
                                    /* stardata for logging only */
                                    struct stardata_t * stardata)
{
    /* 
     * Set giant branch timescales 
     */                 
    Dprint("Set GB timescales\n");

    /* 
     * Base of the giant branch luminosity
     */
    luminosities[L_BGB] = lbgbf(mass,giant_branch_parameters);
    Dprint("LBGB = %30.20e\n",luminosities[L_BGB]);
    
    const double y=iq/(GB[GB_EFFECTIVE_AH]*GB[GB_B]);
    const double y2=ip/(GB[GB_EFFECTIVE_AH]*GB[GB_D]);
    Dprint("y = %30.20e ... y2 = %30.20e\n",y,y2);

    /* Eq. 40 */
    timescales[T_GIANT_TINF_1] = timescales[T_BGB] +
        y2*pow((GB[GB_D]/luminosities[L_BGB]),GBp);

    const double ilX=1.0/luminosities[L_LMX];
   
    /* this is tx of Eq. 41 */
    timescales[T_GIANT_TX] = timescales[T_GIANT_TINF_1] - 
        (timescales[T_GIANT_TINF_1] - timescales[T_BGB])*pow(luminosities[L_BGB]*ilX,GBp);
                
    /* Eq. 43 */
    timescales[T_GIANT_TINF_2] = timescales[T_GIANT_TX] +y*pow(GB[GB_B]*ilX,GBq);

    Dprint("GB timescales %30.20e %30.20e %30.20e\n",
           timescales[T_GIANT_TINF_1],
           timescales[T_GIANT_TINF_2],
           timescales[T_GIANT_TX]);

    /*
     * Set Helium ignition time
     */
    Dprint("Calc He burning luminosity and timescale\n");

    const double ilHe = 1.0/luminosities[L_HE_IGNITION];
    if(Less_or_equal(luminosities[L_HE_IGNITION],luminosities[L_LMX]))
    {
        timescales[T_HE_IGNITION] = timescales[T_GIANT_TINF_1] - 
            y2*pow(GB[GB_D]*ilHe,GBp);
    }
    else
    {
        timescales[T_HE_IGNITION] = timescales[T_GIANT_TINF_2] - 
            y*pow(GB[GB_B]*ilHe,GBq);
    }
    timescales[T_HE_IGNITION] = Max(0.0, timescales[T_HE_IGNITION]);
    
    Dprint("HE_IGNITION t=%30.20e L=%30.23e\n",
           timescales[T_HE_IGNITION],
           luminosities[L_HE_IGNITION]);

    if(Less_or_equal(mass,metallicity_parameters[ZPAR_MASS_HE_FLASH]))
    {
        double mc1 =
            mcgbf(luminosities[L_HE_IGNITION],
                  GB,
                  luminosities[L_LMX]);
                 

        luminosities[L_HE_BURNING] =
            lzahbf(mass,
                   mc1,
                   metallicity_parameters[ZPAR_MASS_HE_FLASH],
                   giant_branch_parameters);
        
        timescales[T_HE_BURNING] =
            thef(mass,
                 mc1,
                 metallicity_parameters[ZPAR_MASS_HE_FLASH],
                 giant_branch_parameters);
        
        Dprint("M<=Mflash : L=%30.20e timescale=%30.20e\n",
               luminosities[L_HE_BURNING],
               timescales[T_HE_BURNING]);
    }
    else
    {
        luminosities[L_HE_BURNING] =
            lhef(mass,
                 giant_branch_parameters)
            *luminosities[L_HE_IGNITION];
                            
        timescales[T_HE_BURNING] =
            thef(mass,
                 1.0,
                 metallicity_parameters[ZPAR_MASS_HE_FLASH],
                 giant_branch_parameters)
            *timescales[T_BGB];

        Dprint("M>Mflash : L=%30.20e timescale=%30.20e\n",
               luminosities[L_HE_BURNING],
               timescales[T_HE_BURNING]);

    }



}
#endif//BSE
