#include "../binary_c.h"
#ifdef BSE
void stellar_timescales_low_mass_AGB(const double phase_start_mass,
                                     const double mass,
                                     const double mcbagb,
                                     const double ip,
                                     const double iq,
                                     const double mp,
                                     const double mq,
                                     double * RESTRICT tn,
                                     const double * RESTRICT const timescales,
                                     const double * RESTRICT const luminosities,
                                     const double * RESTRICT const GB,
                                     const double * RESTRICT const giant_branch_parameters,
                                     const double * RESTRICT const metallicity_parameters,
                                     struct star_t * const star,
                                     struct stardata_t * const stardata)
{ 
    if(phase_start_mass>metallicity_parameters[ZPAR_MASS_FGB])
    {
        double mc1 = mcheif(phase_start_mass,
                            metallicity_parameters[ZPAR_MASS_HE_FLASH],
                            metallicity_parameters[10],
                            giant_branch_parameters);
                           
        *tn = timescales[T_HE_IGNITION];
                             
        if (mass>mc1) *tn += timescales[T_HE_BURNING]*((mass - mc1)/(mcbagb - mc1));
    }
    else if (Less_or_equal(phase_start_mass,metallicity_parameters[ZPAR_MASS_HE_FLASH]))
    {
        double mc1 = mcgbf(luminosities[L_BGB],
                           GB,
                           luminosities[L_LMX]);
                          
                           
        if (Less_or_equal(mass,mc1))
        {
            *tn = timescales[T_BGB];
        }
        else
        {
            double mc2 = mcgbf(luminosities[L_HE_IGNITION],
                               GB,
                               luminosities[L_LMX]);
                              
            if(Less_or_equal(mass,mc2))
            {
                if (Less_or_equal(mass,GB[GB_Mx]))
                {
                    *tn = timescales[T_GIANT_TINF_1] - (ip/(GB[GB_EFFECTIVE_AH]*GB[GB_D]))*pow(mass,mp);
                }
                else
                {
                    *tn = timescales[T_GIANT_TINF_2] - (iq/(GB[GB_EFFECTIVE_AH]*GB[GB_B]))*pow(mass,mq);
                }
            }
            else
            {
                *tn = timescales[T_HE_IGNITION] + timescales[T_HE_BURNING]*((mass - mc2)/(mcbagb - mc2));
            }
        }
    }
    else
    {
        double mc1 = mcheif(phase_start_mass,
                            metallicity_parameters[ZPAR_MASS_HE_FLASH],
                            metallicity_parameters[9],
                            giant_branch_parameters);

        if (Less_or_equal(mass,mc1))
        {
            *tn = timescales[T_BGB];
        }
        else
        {
            double mc2 = mcheif(phase_start_mass,
                                metallicity_parameters[ZPAR_MASS_HE_FLASH],
                                metallicity_parameters[10],
                                giant_branch_parameters);
                                                          
            if (Less_or_equal(mass,mc2))
            {
                *tn = timescales[T_BGB] + 
                    (timescales[T_HE_IGNITION] - timescales[T_BGB])
                    *((mass - mc1)/(mc2 - mc1));
            }
            else
            {
                *tn = timescales[T_HE_IGNITION] + timescales[T_HE_BURNING]
                    *((mass - mc2)/(mcbagb - mc2));
            }
        }
    }    
}

#endif//BSE
